//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

using System.Collections;
using System.Threading;

namespace CLRUnleashed
{

	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class ValuesAndReferences
	{
		private static void StaticStringModifier(string s)
		{
			s = "that";
		}

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			float a = 1.0F;
			float b = 1.0F;
			Console.WriteLine("a == b -> {0} ({1})", a == b, a.GetType());

			object ao;
			object bo;
			ao = a;
			bo = b;
			Console.WriteLine("obiekt a == obiekt b -> {0} {1} ({2})", ao.Equals(bo), ao == bo, ao.GetType().BaseType);

			string astr = "this";
			string bstr = "this";
			Console.WriteLine("cig a == cig b -> {0} ({1})", astr == bstr, astr.GetType().BaseType);

			Console.WriteLine("Przed: {0}", astr);
			StaticStringModifier(astr);
			Console.WriteLine("Po: {0}", astr);
		}
	}
}
